"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
const moment_1 = tslib_1.__importDefault(require("moment"));
const redux_1 = require("redux");
const dist_1 = require("typescript-fsa-reducers/dist");
const actions_1 = require("./actions");
exports.initialMetricTimeState = {
    timeRange: {
        from: moment_1.default()
            .subtract(1, 'hour')
            .valueOf(),
        to: moment_1.default().valueOf(),
        interval: '>=1m',
    },
    updatePolicy: {
        policy: 'manual',
    },
};
const timeRangeReducer = dist_1.reducerWithInitialState(exports.initialMetricTimeState.timeRange).case(actions_1.setRangeTime, (state, { to, from }) => ({ ...state, to, from }));
const updatePolicyReducer = dist_1.reducerWithInitialState(exports.initialMetricTimeState.updatePolicy)
    .case(actions_1.startMetricsAutoReload, () => ({
    policy: 'interval',
    interval: 5000,
}))
    .case(actions_1.stopMetricsAutoReload, () => ({
    policy: 'manual',
}));
exports.metricTimeReducer = redux_1.combineReducers({
    timeRange: timeRangeReducer,
    updatePolicy: updatePolicyReducer,
});
