"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const redux_1 = require("redux");
const dist_1 = require("typescript-fsa-reducers/dist");
const actions_1 = require("./actions");
exports.initialLogTextviewState = {
    scale: 'medium',
    wrap: true,
};
const textviewScaleReducer = dist_1.reducerWithInitialState(exports.initialLogTextviewState.scale).case(actions_1.setTextviewScale, (state, scale) => scale);
const textviewWrapReducer = dist_1.reducerWithInitialState(exports.initialLogTextviewState.wrap).case(actions_1.setTextviewWrap, (state, wrap) => wrap);
exports.logTextviewReducer = redux_1.combineReducers({
    scale: textviewScaleReducer,
    wrap: textviewWrapReducer,
});
