"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const dist_1 = require("typescript-fsa-reducers/dist");
const actions_1 = require("./actions");
exports.initialLogMinimapState = {
    intervalSize: 1000 * 60 * 60 * 24,
};
exports.logMinimapReducer = dist_1.reducerWithInitialState(exports.initialLogMinimapState)
    .case(actions_1.setMinimapIntervalSize, (state, intervalSize) => ({
    intervalSize,
}))
    .build();
