"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const redux_1 = require("redux");
const typescript_fsa_reducers_1 = require("typescript-fsa-reducers");
const actions_1 = require("./actions");
var FlyoutVisibility;
(function (FlyoutVisibility) {
    FlyoutVisibility["hidden"] = "hidden";
    FlyoutVisibility["visible"] = "visible";
})(FlyoutVisibility = exports.FlyoutVisibility || (exports.FlyoutVisibility = {}));
exports.initialFlyoutOptionsState = {
    visibility: FlyoutVisibility.hidden,
    itemId: '',
};
const currentFlyoutReducer = typescript_fsa_reducers_1.reducerWithInitialState(exports.initialFlyoutOptionsState.itemId).case(actions_1.setFlyoutItem, (current, target) => target);
const currentFlyoutVisibilityReducer = typescript_fsa_reducers_1.reducerWithInitialState(exports.initialFlyoutOptionsState.visibility)
    .case(actions_1.hideFlyout, () => FlyoutVisibility.hidden)
    .case(actions_1.showFlyout, () => FlyoutVisibility.visible);
exports.flyoutOptionsReducer = redux_1.combineReducers({
    itemId: currentFlyoutReducer,
    visibility: currentFlyoutVisibilityReducer,
});
