"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const auto_sizer_1 = require("../../components/auto_sizer");
const log_minimap_1 = require("../../components/logging/log_minimap");
const log_text_stream_1 = require("../../components/logging/log_text_stream");
const page_1 = require("../../components/page");
const with_log_minimap_1 = require("../../containers/logs/with_log_minimap");
const with_log_position_1 = require("../../containers/logs/with_log_position");
const with_log_textview_1 = require("../../containers/logs/with_log_textview");
const with_stream_items_1 = require("../../containers/logs/with_stream_items");
const with_summary_1 = require("../../containers/logs/with_summary");
exports.LogsPageContent = ({ showFlyout, setFlyoutItem }) => (react_1.default.createElement(page_1.PageContent, null,
    react_1.default.createElement(auto_sizer_1.AutoSizer, { content: true }, ({ measureRef, content: { width = 0, height = 0 } }) => (react_1.default.createElement(LogPageEventStreamColumn, { innerRef: measureRef },
        react_1.default.createElement(with_log_textview_1.WithLogTextview, null, ({ textScale, wrap }) => (react_1.default.createElement(with_log_position_1.WithLogPosition, null, ({ isAutoReloading, jumpToTargetPosition, reportVisiblePositions, targetPosition, }) => (react_1.default.createElement(with_stream_items_1.WithStreamItems, null, ({ hasMoreAfterEnd, hasMoreBeforeStart, isLoadingMore, isReloading, items, lastLoadedTime, loadNewerEntries, }) => (react_1.default.createElement(log_text_stream_1.ScrollableLogTextStreamView, { hasMoreAfterEnd: hasMoreAfterEnd, hasMoreBeforeStart: hasMoreBeforeStart, height: height, isLoadingMore: isLoadingMore, isReloading: isReloading, isStreaming: isAutoReloading, items: items, jumpToTarget: jumpToTargetPosition, lastLoadedTime: lastLoadedTime, loadNewerItems: loadNewerEntries, reportVisibleInterval: reportVisiblePositions, scale: textScale, target: targetPosition, width: width, wrap: wrap, setFlyoutItem: setFlyoutItem, showFlyout: showFlyout })))))))))),
    react_1.default.createElement(auto_sizer_1.AutoSizer, { content: true }, ({ measureRef, content: { width = 0, height = 0 } }) => {
        return (react_1.default.createElement(LogPageMinimapColumn, { innerRef: measureRef },
            react_1.default.createElement(with_log_minimap_1.WithLogMinimap, null, ({ intervalSize }) => (react_1.default.createElement(with_summary_1.WithSummary, null, ({ buckets }) => (react_1.default.createElement(with_log_position_1.WithLogPosition, null, ({ jumpToTargetPosition, reportVisibleSummary, visibleMidpointTime, visibleTimeInterval, }) => (react_1.default.createElement(log_minimap_1.LogMinimap, { height: height, width: width, highlightedInterval: visibleTimeInterval, intervalSize: intervalSize, jumpToTarget: jumpToTargetPosition, reportVisibleInterval: reportVisibleSummary, summaryBuckets: buckets, target: visibleMidpointTime })))))))));
    })));
const LogPageEventStreamColumn = styled_components_1.default.div `
  flex: 1 0 0%;
  overflow: hidden;
  display: flex;
  flex-direction: column;
`;
const LogPageMinimapColumn = styled_components_1.default.div `
  flex: 1 0 0%;
  overflow: hidden;
  min-width: 100px;
  max-width: 100px;
  display: flex;
  flex-direction: column;
`;
