"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
var _a;
"use strict";
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importDefault(require("react"));
const page_content_1 = require("./page_content");
const toolbar_1 = require("./toolbar");
const no_indices_1 = require("../../components/empty_states/no_indices");
const header_1 = require("../../components/header");
const page_1 = require("../../components/page");
const header_feedback_link_1 = require("../../components/header_feedback_link");
const source_configuration_1 = require("../../components/source_configuration");
const source_configuration_flyout_state_1 = require("../../components/source_configuration/source_configuration_flyout_state");
const with_waffle_filters_1 = require("../../containers/waffle/with_waffle_filters");
const with_waffle_options_1 = require("../../containers/waffle/with_waffle_options");
const with_waffle_time_1 = require("../../containers/waffle/with_waffle_time");
const with_kibana_chrome_1 = require("../../containers/with_kibana_chrome");
const with_source_1 = require("../../containers/with_source");
exports.HomePage = react_1.injectI18n((_a = class extends react_2.default.Component {
        render() {
            const { intl } = this.props;
            return (react_2.default.createElement(page_1.ColumnarPage, null,
                react_2.default.createElement(header_1.Header, { appendSections: react_2.default.createElement(header_feedback_link_1.InfraHeaderFeedbackLink, { url: "https://discuss.elastic.co/c/infrastructure" }), breadcrumbs: [
                        {
                            href: '#/',
                            text: intl.formatMessage({
                                id: 'xpack.infra.header.infrastructureTitle',
                                defaultMessage: 'Infrastructure',
                            }),
                        },
                    ] }),
                react_2.default.createElement(source_configuration_1.SourceConfigurationFlyout, null),
                react_2.default.createElement(with_source_1.WithSource, null, ({ derivedIndexPattern, hasFailed, isLoading, lastFailureMessage, load, metricIndicesExist, }) => isLoading ? (react_2.default.createElement(with_source_1.SourceLoadingPage, null)) : metricIndicesExist ? (react_2.default.createElement(react_2.default.Fragment, null,
                    react_2.default.createElement(with_waffle_time_1.WithWaffleTimeUrlState, null),
                    react_2.default.createElement(with_waffle_filters_1.WithWaffleFilterUrlState, { indexPattern: derivedIndexPattern }),
                    react_2.default.createElement(with_waffle_options_1.WithWaffleOptionsUrlState, null),
                    react_2.default.createElement(toolbar_1.HomeToolbar, null),
                    react_2.default.createElement(page_content_1.HomePageContent, null))) : hasFailed ? (react_2.default.createElement(with_source_1.SourceErrorPage, { errorMessage: lastFailureMessage || '', retry: load })) : (react_2.default.createElement(with_kibana_chrome_1.WithKibanaChrome, null, ({ basePath }) => (react_2.default.createElement(no_indices_1.NoIndices, { title: intl.formatMessage({
                        id: 'xpack.infra.homePage.noMetricsIndicesTitle',
                        defaultMessage: "Looks like you don't have any metrics indices.",
                    }), message: intl.formatMessage({
                        id: 'xpack.infra.homePage.noMetricsIndicesDescription',
                        defaultMessage: "Let's add some!",
                    }), actions: react_2.default.createElement(eui_1.EuiFlexGroup, null,
                        react_2.default.createElement(eui_1.EuiFlexItem, null,
                            react_2.default.createElement(eui_1.EuiButton, { href: `${basePath}/app/kibana#/home/tutorial_directory/metrics`, color: "primary", fill: true }, intl.formatMessage({
                                id: 'xpack.infra.homePage.noMetricsIndicesInstructionsActionLabel',
                                defaultMessage: 'View setup instructions',
                            }))),
                        react_2.default.createElement(eui_1.EuiFlexItem, null,
                            react_2.default.createElement(source_configuration_flyout_state_1.WithSourceConfigurationFlyoutState, null, ({ enable }) => (react_2.default.createElement(eui_1.EuiButton, { color: "primary", onClick: enable }, intl.formatMessage({
                                id: 'xpack.infra.configureSourceActionLabel',
                                defaultMessage: 'Change source configuration',
                            })))))), "data-test-subj": "noMetricsIndicesPrompt" })))))));
        }
    },
    _a.displayName = 'HomePage',
    _a));
