"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const chrome_1 = tslib_1.__importDefault(require("ui/chrome"));
const uiSettingsKeys = ['k7Design'];
class WithKibanaChrome extends react_1.default.Component {
    constructor() {
        super(...arguments);
        this.state = {
            uiSettings: {
                k7Design: chrome_1.default.getUiSettingsClient().get('k7design'),
            },
            basePath: chrome_1.default.getBasePath(),
        };
    }
    componentDidMount() {
        this.uiSettingsSubscription = chrome_1.default
            .getUiSettingsClient()
            .getUpdate$().subscribe({
            next: ({ key, newValue }) => {
                if (uiSettingsKeys.includes(key)) {
                    this.setState(state => ({
                        ...state,
                        uiSettings: {
                            ...state.uiSettings,
                            [key]: newValue,
                        },
                    }));
                }
            },
        });
    }
    componentWillUnmount() {
        if (this.uiSettingsSubscription) {
            this.uiSettingsSubscription.unsubscribe();
        }
    }
    render() {
        return this.props.children({
            ...this.state,
            setBreadcrumbs: chrome_1.default.breadcrumbs.set,
        });
    }
}
exports.WithKibanaChrome = WithKibanaChrome;
