"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const graphql_tag_1 = tslib_1.__importDefault(require("graphql-tag"));
exports.waffleNodesQuery = graphql_tag_1.default `
  query WaffleNodesQuery(
    $sourceId: ID!
    $timerange: InfraTimerangeInput!
    $filterQuery: String
    $metric: InfraMetricInput!
    $path: [InfraPathInput!]!
  ) {
    source(id: $sourceId) {
      id
      map(timerange: $timerange, filterQuery: $filterQuery) {
        nodes(path: $path, metric: $metric) {
          path {
            value
            label
          }
          metric {
            name
            value
            avg
            max
          }
        }
      }
    }
  }
`;
