"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const constate_1 = require("constate");
const react_1 = tslib_1.__importDefault(require("react"));
const actions = {
    disable: () => state => ({ ...state, value: false }),
    enable: () => state => ({ ...state, value: true }),
    toggle: () => state => ({ ...state, value: !state.value }),
};
exports.WithBinary = ({ initialValue = false, ...props }) => (react_1.default.createElement(constate_1.Container, Object.assign({}, props, { actions: actions, initialState: { value: initialValue }, pure: true })));
