"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const react_redux_1 = require("react-redux");
const reselect_1 = require("reselect");
const store_1 = require("../../store");
const typed_react_1 = require("../../utils/typed_react");
const typed_redux_1 = require("../../utils/typed_redux");
const url_state_1 = require("../../utils/url_state");
exports.withMetricsTime = react_redux_1.connect((state) => ({
    currentTimeRange: store_1.metricTimeSelectors.selectRangeTime(state),
    isAutoReloading: store_1.metricTimeSelectors.selectIsAutoReloading(state),
    urlState: selectTimeUrlState(state),
}), typed_redux_1.bindPlainActionCreators({
    setRangeTime: store_1.metricTimeActions.setRangeTime,
    startMetricsAutoReload: store_1.metricTimeActions.startMetricsAutoReload,
    stopMetricsAutoReload: store_1.metricTimeActions.stopMetricsAutoReload,
}));
exports.WithMetricsTime = typed_react_1.asChildFunctionRenderer(exports.withMetricsTime, {
    onCleanup: ({ stopMetricsAutoReload }) => stopMetricsAutoReload(),
});
exports.WithMetricsTimeUrlState = () => (react_1.default.createElement(exports.WithMetricsTime, null, ({ setRangeTime, startMetricsAutoReload, stopMetricsAutoReload, urlState }) => (react_1.default.createElement(url_state_1.UrlStateContainer, { urlState: urlState, urlStateKey: "metricTime", mapToUrlState: mapToUrlState, onChange: newUrlState => {
        if (newUrlState && newUrlState.time) {
            setRangeTime(newUrlState.time);
        }
        if (newUrlState && newUrlState.autoReload) {
            startMetricsAutoReload();
        }
        else if (newUrlState &&
            typeof newUrlState.autoReload !== 'undefined' &&
            !newUrlState.autoReload) {
            stopMetricsAutoReload();
        }
    }, onInitialize: initialUrlState => {
        if (initialUrlState && initialUrlState.time) {
            setRangeTime(initialUrlState.time);
        }
        if (initialUrlState && initialUrlState.autoReload) {
            startMetricsAutoReload();
        }
    } }))));
const selectTimeUrlState = reselect_1.createSelector(store_1.metricTimeSelectors.selectRangeTime, store_1.metricTimeSelectors.selectIsAutoReloading, (time, autoReload) => ({
    time,
    autoReload,
}));
const mapToUrlState = (value) => value
    ? {
        time: mapToTimeUrlState(value.time),
        autoReload: mapToAutoReloadUrlState(value.autoReload),
    }
    : undefined;
const mapToTimeUrlState = (value) => value && (typeof value.to === 'number' && typeof value.from === 'number') ? value : undefined;
const mapToAutoReloadUrlState = (value) => (typeof value === 'boolean' ? value : undefined);
exports.replaceMetricTimeInQueryString = (from, to) => Number.isNaN(from) || Number.isNaN(to)
    ? (value) => value
    : url_state_1.replaceStateKeyInQueryString('metricTime', {
        autoReload: false,
        time: {
            interval: '>=1m',
            from,
            to,
        },
    });
