"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const react_redux_1 = require("react-redux");
const reselect_1 = require("reselect");
const store_1 = require("../../store");
const typed_react_1 = require("../../utils/typed_react");
const typed_redux_1 = require("../../utils/typed_redux");
exports.withStreamItems = react_redux_1.connect((state) => ({
    isReloading: store_1.logEntriesSelectors.selectIsReloadingEntries(state),
    isLoadingMore: store_1.logEntriesSelectors.selectIsLoadingMoreEntries(state),
    hasMoreBeforeStart: store_1.logEntriesSelectors.selectHasMoreBeforeStart(state),
    hasMoreAfterEnd: store_1.logEntriesSelectors.selectHasMoreAfterEnd(state),
    lastLoadedTime: store_1.logEntriesSelectors.selectEntriesLastLoadedTime(state),
    items: selectItems(state),
}), typed_redux_1.bindPlainActionCreators({
    loadNewerEntries: store_1.logEntriesActions.loadNewerEntries,
}));
exports.WithStreamItems = typed_react_1.asChildFunctionRenderer(exports.withStreamItems);
const selectItems = reselect_1.createSelector(store_1.logEntriesSelectors.selectEntries, store_1.logEntriesSelectors.selectIsReloadingEntries, store_1.logPositionSelectors.selectIsAutoReloading, 
// searchResultsSelectors.selectSearchResultsById,
(logEntries, isReloading, isAutoReloading /*, searchResults*/) => isReloading && !isAutoReloading
    ? []
    : logEntries.map(logEntry => createLogEntryStreamItem(logEntry /*, searchResults[logEntry.gid] || null*/)));
const createLogEntryStreamItem = (logEntry, searchResult) => ({
    kind: 'logEntry',
    logEntry: {
        gid: logEntry.gid,
        origin: {
            id: logEntry.gid,
            index: '',
            type: '',
        },
        fields: {
            time: logEntry.key.time,
            tiebreaker: logEntry.key.tiebreaker,
            message: logEntry.message.map(formatMessageSegment).join(''),
        },
    },
    searchResult,
});
const formatMessageSegment = (messageSegment) => messageSegment.__typename === 'InfraLogMessageFieldSegment'
    ? messageSegment.value
    : messageSegment.__typename === 'InfraLogMessageConstantSegment'
        ? messageSegment.constant
        : 'failed to format message';
