"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const react_redux_1 = require("react-redux");
const reselect_1 = require("reselect");
const time_1 = require("../../../common/time");
const store_1 = require("../../store");
const typed_react_1 = require("../../utils/typed_react");
const typed_redux_1 = require("../../utils/typed_redux");
const url_state_1 = require("../../utils/url_state");
exports.withLogPosition = react_redux_1.connect((state) => ({
    firstVisiblePosition: store_1.logPositionSelectors.selectFirstVisiblePosition(state),
    isAutoReloading: store_1.logPositionSelectors.selectIsAutoReloading(state),
    lastVisiblePosition: store_1.logPositionSelectors.selectFirstVisiblePosition(state),
    targetPosition: store_1.logPositionSelectors.selectTargetPosition(state),
    urlState: selectPositionUrlState(state),
    visibleTimeInterval: store_1.logPositionSelectors.selectVisibleTimeInterval(state),
    visibleMidpoint: store_1.logPositionSelectors.selectVisibleMidpointOrTarget(state),
    visibleMidpointTime: store_1.logPositionSelectors.selectVisibleMidpointOrTargetTime(state),
}), typed_redux_1.bindPlainActionCreators({
    jumpToTargetPosition: store_1.logPositionActions.jumpToTargetPosition,
    jumpToTargetPositionTime: store_1.logPositionActions.jumpToTargetPositionTime,
    reportVisiblePositions: store_1.logPositionActions.reportVisiblePositions,
    reportVisibleSummary: store_1.logPositionActions.reportVisibleSummary,
    startLiveStreaming: store_1.logPositionActions.startAutoReload,
    stopLiveStreaming: store_1.logPositionActions.stopAutoReload,
}));
exports.WithLogPosition = typed_react_1.asChildFunctionRenderer(exports.withLogPosition, {
    onCleanup: ({ stopLiveStreaming }) => stopLiveStreaming(),
});
exports.WithLogPositionUrlState = () => (react_1.default.createElement(exports.WithLogPosition, null, ({ jumpToTargetPosition, jumpToTargetPositionTime, startLiveStreaming, stopLiveStreaming, urlState, }) => (react_1.default.createElement(url_state_1.UrlStateContainer, { urlState: urlState, urlStateKey: "logPosition", mapToUrlState: mapToUrlState, onChange: newUrlState => {
        if (newUrlState && newUrlState.position) {
            jumpToTargetPosition(newUrlState.position);
        }
        if (newUrlState && newUrlState.streamLive) {
            startLiveStreaming(5000);
        }
        else if (newUrlState &&
            typeof newUrlState.streamLive !== 'undefined' &&
            !newUrlState.streamLive) {
            stopLiveStreaming();
        }
    }, onInitialize: initialUrlState => {
        if (initialUrlState && initialUrlState.position) {
            jumpToTargetPosition(initialUrlState.position);
        }
        else {
            jumpToTargetPositionTime(Date.now());
        }
        if (initialUrlState && initialUrlState.streamLive) {
            startLiveStreaming(5000);
        }
    } }))));
const selectPositionUrlState = reselect_1.createSelector(store_1.logPositionSelectors.selectVisibleMidpointOrTarget, store_1.logPositionSelectors.selectIsAutoReloading, (position, streamLive) => ({
    position: position ? time_1.pickTimeKey(position) : null,
    streamLive,
}));
const mapToUrlState = (value) => value
    ? {
        position: mapToPositionUrlState(value.position),
        streamLive: mapToStreamLiveUrlState(value.streamLive),
    }
    : undefined;
const mapToPositionUrlState = (value) => value && (typeof value.time === 'number' && typeof value.tiebreaker === 'number')
    ? time_1.pickTimeKey(value)
    : undefined;
const mapToStreamLiveUrlState = (value) => (typeof value === 'boolean' ? value : undefined);
exports.replaceLogPositionInQueryString = (time) => Number.isNaN(time)
    ? (value) => value
    : url_state_1.replaceStateKeyInQueryString('logPosition', {
        position: {
            time,
            tiebreaker: 0,
        },
    });
