"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const react_1 = tslib_1.__importDefault(require("react"));
const react_redux_1 = require("react-redux");
const reselect_1 = require("reselect");
const store_1 = require("../../store");
const typed_react_1 = require("../../utils/typed_react");
const typed_redux_1 = require("../../utils/typed_redux");
const url_state_1 = require("../../utils/url_state");
exports.withLogMinimap = react_redux_1.connect((state) => ({
    availableIntervalSizes: exports.availableIntervalSizes,
    intervalSize: store_1.logMinimapSelectors.selectMinimapIntervalSize(state),
    urlState: selectMinimapUrlState(state),
}), typed_redux_1.bindPlainActionCreators({
    setIntervalSize: store_1.logMinimapActions.setMinimapIntervalSize,
}));
exports.WithLogMinimap = typed_react_1.asChildFunctionRenderer(exports.withLogMinimap);
exports.availableIntervalSizes = [
    {
        label: i18n_1.i18n.translate('xpack.infra.mapLogs.oneYearLabel', {
            defaultMessage: '1 Year',
        }),
        intervalSize: 1000 * 60 * 60 * 24 * 365,
    },
    {
        label: i18n_1.i18n.translate('xpack.infra.mapLogs.oneMonthLabel', {
            defaultMessage: '1 Month',
        }),
        intervalSize: 1000 * 60 * 60 * 24 * 30,
    },
    {
        label: i18n_1.i18n.translate('xpack.infra.mapLogs.oneWeekLabel', {
            defaultMessage: '1 Week',
        }),
        intervalSize: 1000 * 60 * 60 * 24 * 7,
    },
    {
        label: i18n_1.i18n.translate('xpack.infra.mapLogs.oneDayLabel', {
            defaultMessage: '1 Day',
        }),
        intervalSize: 1000 * 60 * 60 * 24,
    },
    {
        label: i18n_1.i18n.translate('xpack.infra.mapLogs.oneHourLabel', {
            defaultMessage: '1 Hour',
        }),
        intervalSize: 1000 * 60 * 60,
    },
    {
        label: i18n_1.i18n.translate('xpack.infra.mapLogs.oneMinuteLabel', {
            defaultMessage: '1 Minute',
        }),
        intervalSize: 1000 * 60,
    },
];
exports.WithLogMinimapUrlState = () => (react_1.default.createElement(exports.WithLogMinimap, null, ({ urlState, setIntervalSize }) => (react_1.default.createElement(url_state_1.UrlStateContainer, { urlState: urlState, urlStateKey: "logMinimap", mapToUrlState: mapToUrlState, onChange: newUrlState => {
        if (newUrlState && newUrlState.intervalSize) {
            setIntervalSize(newUrlState.intervalSize);
        }
    }, onInitialize: newUrlState => {
        if (newUrlState && newUrlState.intervalSize) {
            setIntervalSize(newUrlState.intervalSize);
        }
    } }))));
const mapToUrlState = (value) => value
    ? {
        intervalSize: mapToIntervalSizeUrlState(value.intervalSize),
    }
    : undefined;
const mapToIntervalSizeUrlState = (value) => value && typeof value === 'number' ? value : undefined;
const selectMinimapUrlState = reselect_1.createSelector(store_1.logMinimapSelectors.selectMinimapIntervalSize, intervalSize => ({
    intervalSize,
}));
