"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const react_redux_1 = require("react-redux");
const reselect_1 = require("reselect");
const lodash_1 = require("lodash");
const store_1 = require("../../store");
const log_flyout_1 = require("../../store/local/log_flyout");
const typed_react_1 = require("../../utils/typed_react");
const typed_redux_1 = require("../../utils/typed_redux");
const url_state_1 = require("../../utils/url_state");
const selectOptionsUrlState = reselect_1.createSelector(store_1.flyoutOptionsSelectors.selectFlyoutId, store_1.flyoutOptionsSelectors.selectFlyoutVisibility, (flyoutId, flyoutVisibility) => ({
    flyoutVisibility,
    flyoutId,
}));
exports.withFlyoutOptions = react_redux_1.connect((state) => ({
    flyoutVisibility: store_1.flyoutOptionsSelectors.selectFlyoutVisibility(state),
    flyoutId: store_1.flyoutOptionsSelectors.selectFlyoutId(state),
    urlState: selectOptionsUrlState(state),
}), typed_redux_1.bindPlainActionCreators({
    setFlyoutItem: store_1.flyoutOptionsActions.setFlyoutItem,
    showFlyout: store_1.flyoutOptionsActions.showFlyout,
    hideFlyout: store_1.flyoutOptionsActions.hideFlyout,
}));
exports.WithFlyoutOptions = typed_react_1.asChildFunctionRenderer(exports.withFlyoutOptions);
exports.WithFlyoutOptionsUrlState = () => (react_1.default.createElement(exports.WithFlyoutOptions, null, ({ setFlyoutItem, showFlyout, hideFlyout, urlState }) => (react_1.default.createElement(url_state_1.UrlStateContainer, { urlState: urlState, urlStateKey: "flyoutOptions", mapToUrlState: mapToUrlState, onChange: newUrlState => {
        if (newUrlState && newUrlState.flyoutId) {
            setFlyoutItem(newUrlState.flyoutId);
        }
        if (newUrlState && newUrlState.flyoutVisibility === log_flyout_1.FlyoutVisibility.visible) {
            showFlyout();
        }
        if (newUrlState && newUrlState.flyoutVisibility === log_flyout_1.FlyoutVisibility.hidden) {
            hideFlyout();
        }
    }, onInitialize: initialUrlState => {
        if (initialUrlState && initialUrlState.flyoutId) {
            setFlyoutItem(initialUrlState.flyoutId);
        }
        if (initialUrlState && initialUrlState.flyoutVisibility === log_flyout_1.FlyoutVisibility.visible) {
            showFlyout();
        }
        if (initialUrlState && initialUrlState.flyoutVisibility === log_flyout_1.FlyoutVisibility.hidden) {
            hideFlyout();
        }
    } }))));
const mapToUrlState = (value) => value
    ? {
        flyoutId: mapToFlyoutIdState(value.flyoutId),
        flyoutVisibility: mapToFlyoutVisibilityState(value.flyoutVisibility),
    }
    : undefined;
const mapToFlyoutIdState = (subject) => {
    return subject && lodash_1.isString(subject) ? subject : undefined;
};
const mapToFlyoutVisibilityState = (subject) => {
    if (subject) {
        if (subject === 'visible') {
            return log_flyout_1.FlyoutVisibility.visible;
        }
        if (subject === 'hidden') {
            return log_flyout_1.FlyoutVisibility.hidden;
        }
    }
};
