"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const react_apollo_1 = require("react-apollo");
const log_flyout_1 = require("../../store/local/log_flyout");
const flyout_item_gql_query_1 = require("./flyout_item.gql_query");
const with_log_flyout_options_1 = require("./with_log_flyout_options");
exports.WithLogFlyout = ({ children, sourceId }) => {
    return (react_1.default.createElement(with_log_flyout_options_1.WithFlyoutOptions, null, ({ showFlyout, hideFlyout, setFlyoutItem, flyoutId, flyoutVisibility }) => flyoutVisibility === log_flyout_1.FlyoutVisibility.visible ? (react_1.default.createElement(react_apollo_1.Query, { query: flyout_item_gql_query_1.flyoutItemQuery, fetchPolicy: "no-cache", variables: {
            itemId: (flyoutId != null && flyoutId) || '',
            sourceId,
        } }, ({ data, error, loading }) => {
        return children({
            showFlyout,
            hideFlyout,
            setFlyoutItem,
            flyoutItem: (data && data.source && data.source.logItem) || null,
            error: error && error.message,
            loading,
        });
    })) : null));
};
