"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const react_redux_1 = require("react-redux");
const store_1 = require("../../store");
const kuery_1 = require("../../utils/kuery");
const typed_react_1 = require("../../utils/typed_react");
const typed_redux_1 = require("../../utils/typed_redux");
const url_state_1 = require("../../utils/url_state");
const withLogFilter = react_redux_1.connect((state) => ({
    filterQuery: store_1.logFilterSelectors.selectLogFilterQuery(state),
    filterQueryDraft: store_1.logFilterSelectors.selectLogFilterQueryDraft(state),
    isFilterQueryDraftValid: store_1.logFilterSelectors.selectIsLogFilterQueryDraftValid(state),
}), (dispatch, ownProps) => typed_redux_1.bindPlainActionCreators({
    applyFilterQuery: (query) => store_1.logFilterActions.applyLogFilterQuery({
        query,
        serializedQuery: kuery_1.convertKueryToElasticSearchQuery(query.expression, ownProps.indexPattern),
    }),
    applyFilterQueryFromKueryExpression: (expression) => store_1.logFilterActions.applyLogFilterQuery({
        query: {
            kind: 'kuery',
            expression,
        },
        serializedQuery: kuery_1.convertKueryToElasticSearchQuery(expression, ownProps.indexPattern),
    }),
    setFilterQueryDraft: store_1.logFilterActions.setLogFilterQueryDraft,
    setFilterQueryDraftFromKueryExpression: (expression) => store_1.logFilterActions.setLogFilterQueryDraft({
        kind: 'kuery',
        expression,
    }),
})(dispatch));
exports.WithLogFilter = typed_react_1.asChildFunctionRenderer(withLogFilter);
exports.WithLogFilterUrlState = ({ indexPattern }) => (react_1.default.createElement(exports.WithLogFilter, { indexPattern: indexPattern }, ({ applyFilterQuery, filterQuery }) => (react_1.default.createElement(url_state_1.UrlStateContainer, { urlState: filterQuery, urlStateKey: "logFilter", mapToUrlState: mapToFilterQuery, onChange: urlState => {
        if (urlState) {
            applyFilterQuery(urlState);
        }
    }, onInitialize: urlState => {
        if (urlState) {
            applyFilterQuery(urlState);
        }
    } }))));
const mapToFilterQuery = (value) => value && value.kind === 'kuery' && typeof value.expression === 'string'
    ? {
        kind: value.kind,
        expression: value.expression,
    }
    : undefined;
exports.replaceLogFilterInQueryString = (expression) => url_state_1.replaceStateKeyInQueryString('logFilter', {
    kind: 'kuery',
    expression,
});
