"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = tslib_1.__importDefault(require("react"));
const react_2 = require("@kbn/i18n/react");
exports.NameConfigurationPanel = ({ isLoading, nameFieldProps, }) => (react_1.default.createElement(eui_1.EuiForm, null,
    react_1.default.createElement(eui_1.EuiTitle, { size: "s" },
        react_1.default.createElement("h3", null,
            react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.infra.sourceConfiguration.nameSectionTitle", defaultMessage: "Name" }))),
    react_1.default.createElement(eui_1.EuiSpacer, { size: "m" }),
    react_1.default.createElement(eui_1.EuiFormRow, { error: nameFieldProps.error, fullWidth: true, isInvalid: nameFieldProps.isInvalid, label: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.infra.sourceConfiguration.nameLabel", defaultMessage: "Name" }) },
        react_1.default.createElement(eui_1.EuiFieldText, Object.assign({ fullWidth: true, disabled: isLoading, isLoading: isLoading }, nameFieldProps)))));
