"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
var _a;
"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
const i18n_1 = require("@kbn/i18n");
const react_1 = require("@kbn/i18n/react");
const lodash_1 = require("lodash");
const moment_timezone_1 = tslib_1.__importDefault(require("moment-timezone"));
const react_2 = tslib_1.__importStar(require("react"));
const eui_1 = require("@elastic/eui");
var DatePickerDateOptions;
(function (DatePickerDateOptions) {
    DatePickerDateOptions["today"] = "today";
    DatePickerDateOptions["yesterday"] = "yesterday";
    DatePickerDateOptions["thisWeek"] = "this_week";
    DatePickerDateOptions["weekToDate"] = "week_to_date";
    DatePickerDateOptions["thisMonth"] = "this_month";
    DatePickerDateOptions["monthToDate"] = "month_to_date";
    DatePickerDateOptions["thisYear"] = "this_year";
    DatePickerDateOptions["yearToDate"] = "year_to_date";
})(DatePickerDateOptions || (DatePickerDateOptions = {}));
const commonDates = [
    {
        id: DatePickerDateOptions.today,
        label: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.todayText', {
            defaultMessage: 'Today',
        }),
    },
    {
        id: DatePickerDateOptions.yesterday,
        label: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.yesterdayText', {
            defaultMessage: 'Yesterday',
        }),
    },
    {
        id: DatePickerDateOptions.thisWeek,
        label: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.thisWeekText', {
            defaultMessage: 'This week',
        }),
    },
    {
        id: DatePickerDateOptions.weekToDate,
        label: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.weekToDateText', {
            defaultMessage: 'Week to date',
        }),
    },
    {
        id: DatePickerDateOptions.thisMonth,
        label: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.thisMonthText', {
            defaultMessage: 'This month',
        }),
    },
    {
        id: DatePickerDateOptions.monthToDate,
        label: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.monthToDateText', {
            defaultMessage: 'Month to date',
        }),
    },
    {
        id: DatePickerDateOptions.thisYear,
        label: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.thisYearText', {
            defaultMessage: 'This year',
        }),
    },
    {
        id: DatePickerDateOptions.yearToDate,
        label: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.yearToDateText', {
            defaultMessage: 'Year to date',
        }),
    },
];
const singleLastOptions = [
    {
        value: 'seconds',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.singleUnitOptions.secondLabel', {
            defaultMessage: 'second',
        }),
    },
    {
        value: 'minutes',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.singleUnitOptions.minuteLabel', {
            defaultMessage: 'minute',
        }),
    },
    {
        value: 'hours',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.singleUnitOptions.hourLabel', {
            defaultMessage: 'hour',
        }),
    },
    {
        value: 'days',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.singleUnitOptions.dayLabel', {
            defaultMessage: 'day',
        }),
    },
    {
        value: 'weeks',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.singleUnitOptions.weekLabel', {
            defaultMessage: 'week',
        }),
    },
    {
        value: 'months',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.singleUnitOptions.monthLabel', {
            defaultMessage: 'month',
        }),
    },
    {
        value: 'years',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.singleUnitOptions.yearLabel', {
            defaultMessage: 'year',
        }),
    },
];
const pluralLastOptions = [
    {
        value: 'seconds',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.pluralUnitOptions.secondsLabel', {
            defaultMessage: 'seconds',
        }),
    },
    {
        value: 'minutes',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.pluralUnitOptions.minutesLabel', {
            defaultMessage: 'minutes',
        }),
    },
    {
        value: 'hours',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.pluralUnitOptions.hoursLabel', {
            defaultMessage: 'hours',
        }),
    },
    {
        value: 'days',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.pluralUnitOptions.daysLabel', {
            defaultMessage: 'days',
        }),
    },
    {
        value: 'weeks',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.pluralUnitOptions.weeksLabel', {
            defaultMessage: 'weeks',
        }),
    },
    {
        value: 'months',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.pluralUnitOptions.monthsLabel', {
            defaultMessage: 'months',
        }),
    },
    {
        value: 'years',
        text: i18n_1.i18n.translate('xpack.infra.rangeDatePicker.pluralUnitOptions.yearsLabel', {
            defaultMessage: 'years',
        }),
    },
];
exports.RangeDatePicker = react_1.injectI18n((_a = class extends react_2.default.PureComponent {
        constructor() {
            super(...arguments);
            this.state = {
                startDate: this.props.startDate,
                endDate: this.props.endDate,
                isPopoverOpen: false,
                recentlyUsed: [],
                quickSelectTime: 1,
                quickSelectUnit: 'hours',
            };
            this.handleChangeStart = (date) => {
                if (date && this.state.startDate !== date) {
                    this.props.onChangeRangeTime(date, this.state.endDate, false);
                    this.setState({
                        startDate: date,
                    });
                }
            };
            this.handleChangeEnd = (date) => {
                if (date && this.state.endDate !== date) {
                    this.props.onChangeRangeTime(this.state.startDate, date, false);
                    this.setState({
                        endDate: date,
                    });
                }
            };
            this.onButtonClick = () => {
                this.setState({
                    isPopoverOpen: !this.state.isPopoverOpen,
                });
            };
            this.closePopover = (type, from, to) => {
                const { startDate, endDate, recentlyUsed } = this.managedStartEndDateFromType(type, from, to);
                this.setState({
                    ...this.state,
                    isPopoverOpen: false,
                    startDate,
                    endDate,
                    recentlyUsed,
                }, () => {
                    if (type) {
                        this.props.onChangeRangeTime(startDate, endDate, true);
                    }
                });
            };
            this.renderQuickSelect = () => {
                const { intl } = this.props;
                return (react_2.default.createElement(react_2.Fragment, null,
                    react_2.default.createElement(eui_1.EuiTitle, { size: "xxxs" },
                        react_2.default.createElement("span", null,
                            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.rangeDatePicker.quickSelectTitle", defaultMessage: "Quick select" }))),
                    react_2.default.createElement(eui_1.EuiSpacer, { size: "s" }),
                    react_2.default.createElement(eui_1.EuiFlexGroup, { gutterSize: "s", responsive: false },
                        react_2.default.createElement(eui_1.EuiFlexItem, null,
                            react_2.default.createElement(eui_1.EuiTitle, { size: "s" },
                                react_2.default.createElement("span", null,
                                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.rangeDatePicker.lastQuickSelectTitle", defaultMessage: "Last" })))),
                        react_2.default.createElement(eui_1.EuiFlexItem, null,
                            react_2.default.createElement(eui_1.EuiFormRow, null,
                                react_2.default.createElement(eui_1.EuiFieldNumber, { "aria-label": intl.formatMessage({
                                        id: 'xpack.infra.rangeDatePicker.countOfFormRowAriaLabel',
                                        defaultMessage: 'Count of',
                                    }), defaultValue: "1", value: this.state.quickSelectTime, step: 0, onChange: arg => {
                                        this.onChange('quickSelectTime', arg);
                                    } }))),
                        react_2.default.createElement(eui_1.EuiFlexItem, null,
                            react_2.default.createElement(eui_1.EuiFormRow, null,
                                react_2.default.createElement(eui_1.EuiSelect, { value: this.state.quickSelectUnit, options: this.state.quickSelectTime === 1 ? singleLastOptions : pluralLastOptions, onChange: arg => {
                                        this.onChange('quickSelectUnit', arg);
                                    } }))),
                        react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
                            react_2.default.createElement(eui_1.EuiFormRow, null,
                                react_2.default.createElement(eui_1.EuiButton, { onClick: () => this.closePopover('quick-select'), style: { minWidth: 0 } },
                                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.rangeDatePicker.applyFormRowButtonLabel", defaultMessage: "Apply" })))))));
            };
            this.onChange = (stateType, args) => {
                let value = args.currentTarget.value;
                if (stateType === 'quickSelectTime' && value !== '') {
                    value = parseInt(args.currentTarget.value, 10);
                }
                this.setState({
                    ...this.state,
                    [stateType]: value,
                });
            };
            this.renderCommonlyUsed = (recentlyCommonDates) => {
                const links = recentlyCommonDates.map(date => {
                    return (react_2.default.createElement(eui_1.EuiFlexItem, { key: date.id },
                        react_2.default.createElement(eui_1.EuiLink, { onClick: () => this.closePopover(date.id) }, date.label)));
                });
                return (react_2.default.createElement(react_2.Fragment, null,
                    react_2.default.createElement(eui_1.EuiTitle, { size: "xxxs" },
                        react_2.default.createElement("span", null,
                            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.rangeDatePicker.renderCommonlyUsedLinksTitle", defaultMessage: "Commonly used" }))),
                    react_2.default.createElement(eui_1.EuiSpacer, { size: "s" }),
                    react_2.default.createElement(eui_1.EuiText, { size: "s" },
                        react_2.default.createElement(eui_1.EuiFlexGrid, { gutterSize: "s", columns: 2 }, links))));
            };
            this.renderRecentlyUsed = (recentDates) => {
                const links = recentDates.map((date) => {
                    let dateRange;
                    let dateLink = (react_2.default.createElement(eui_1.EuiLink, { onClick: () => this.closePopover(date.type) }, dateRange || date.text));
                    if (typeof date.text !== 'string') {
                        dateRange = `${date.text[0]} – ${date.text[1]}`;
                        dateLink = (react_2.default.createElement(eui_1.EuiLink, { onClick: () => this.closePopover(date.type, date.text[0], date.text[1]) }, dateRange || date.type));
                    }
                    return (react_2.default.createElement(eui_1.EuiFlexItem, { grow: false, key: `${dateRange || date.type}` }, dateLink));
                });
                return (react_2.default.createElement(react_2.Fragment, null,
                    react_2.default.createElement(eui_1.EuiTitle, { size: "xxxs" },
                        react_2.default.createElement("span", null,
                            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.infra.rangeDatePicker.recentlyUsedDateRangesTitle", defaultMessage: "Recently used date ranges" }))),
                    react_2.default.createElement(eui_1.EuiSpacer, { size: "s" }),
                    react_2.default.createElement(eui_1.EuiText, { size: "s" },
                        react_2.default.createElement(eui_1.EuiFlexGroup, { gutterSize: "s", style: { flexDirection: 'column' } }, links))));
            };
        }
        render() {
            const { isLoading, disabled, intl } = this.props;
            const { startDate, endDate } = this.state;
            const quickSelectButton = (react_2.default.createElement(eui_1.EuiButtonEmpty, { className: "euiFormControlLayout__prepend", style: { borderRight: 'none' }, onClick: this.onButtonClick, disabled: disabled, "aria-label": intl.formatMessage({
                    id: 'xpack.infra.rangeDatePicker.dateQuickSelectAriaLabel',
                    defaultMessage: 'Date quick select',
                }), size: "xs", iconType: "arrowDown", iconSide: "right" },
                react_2.default.createElement(eui_1.EuiIcon, { type: "calendar" })));
            const commonlyUsed = this.renderCommonlyUsed(commonDates);
            const recentlyUsed = this.renderRecentlyUsed([
                ...this.state.recentlyUsed,
                ...this.props.recentlyUsed,
            ]);
            const quickSelectPopover = (react_2.default.createElement(eui_1.EuiPopover, { id: "QuickSelectPopover", button: quickSelectButton, isOpen: this.state.isPopoverOpen, closePopover: this.closePopover.bind(this), anchorPosition: "downLeft", ownFocus: true },
                react_2.default.createElement("div", { style: { width: '400px' } },
                    this.renderQuickSelect(),
                    react_2.default.createElement(eui_1.EuiHorizontalRule, null),
                    commonlyUsed,
                    react_2.default.createElement(eui_1.EuiHorizontalRule, null),
                    recentlyUsed)));
            return (react_2.default.createElement(eui_1.EuiFormControlLayout, { prepend: quickSelectPopover },
                react_2.default.createElement(eui_1.EuiDatePickerRange, { className: "euiDatePickerRange--inGroup", iconType: false, fullWidth: true, startDateControl: react_2.default.createElement(eui_1.EuiDatePicker, { dateFormat: "L LTS", selected: startDate, onChange: this.handleChangeStart, isInvalid: startDate && endDate ? startDate > endDate : false, fullWidth: true, "aria-label": intl.formatMessage({
                            id: 'xpack.infra.rangeDatePicker.startDateAriaLabel',
                            defaultMessage: 'Start date',
                        }), disabled: disabled, shouldCloseOnSelect: true, showTimeSelect: true }), endDateControl: react_2.default.createElement(eui_1.EuiDatePicker, { dateFormat: "L LTS", selected: endDate, onChange: this.handleChangeEnd, isInvalid: startDate && endDate ? startDate > endDate : false, fullWidth: true, disabled: disabled, isLoading: isLoading, "aria-label": intl.formatMessage({
                            id: 'xpack.infra.rangeDatePicker.endDateAriaLabel',
                            defaultMessage: 'End date',
                        }), shouldCloseOnSelect: true, showTimeSelect: true, popperPlacement: "top-end" }) })));
        }
        resetRangeDate(startDate, endDate) {
            this.setState({
                ...this.state,
                startDate,
                endDate,
            });
        }
        managedStartEndDateFromType(type, from, to) {
            const { intl } = this.props;
            let { startDate, endDate } = this.state;
            let recentlyUsed = this.state.recentlyUsed;
            let textJustUsed = type;
            if (type === 'quick-select') {
                textJustUsed = intl.formatMessage({
                    id: 'xpack.infra.rangeDatePicker.lastQuickSelectTimeText',
                    defaultMessage: 'Last {quickSelectTime} {quickSelectUnit}',
                }, {
                    quickSelectTime: this.state.quickSelectTime,
                    quickSelectUnit: this.state.quickSelectTime === 1
                        ? lodash_1.get(lodash_1.find(singleLastOptions, { value: this.state.quickSelectUnit }), 'text')
                        : lodash_1.get(lodash_1.find(pluralLastOptions, { value: this.state.quickSelectUnit }), 'text'),
                });
                startDate = moment_timezone_1.default().subtract(this.state.quickSelectTime, this.state
                    .quickSelectUnit);
                endDate = moment_timezone_1.default();
            }
            else if (type === DatePickerDateOptions.today) {
                startDate = moment_timezone_1.default().startOf('day');
                endDate = moment_timezone_1.default()
                    .startOf('day')
                    .add(24, 'hour');
            }
            else if (type === DatePickerDateOptions.yesterday) {
                startDate = moment_timezone_1.default()
                    .subtract(1, 'day')
                    .startOf('day');
                endDate = moment_timezone_1.default()
                    .subtract(1, 'day')
                    .startOf('day')
                    .add(24, 'hour');
            }
            else if (type === DatePickerDateOptions.thisWeek) {
                startDate = moment_timezone_1.default().startOf('week');
                endDate = moment_timezone_1.default()
                    .startOf('week')
                    .add(1, 'week');
            }
            else if (type === DatePickerDateOptions.weekToDate) {
                startDate = moment_timezone_1.default().subtract(1, 'week');
                endDate = moment_timezone_1.default();
            }
            else if (type === DatePickerDateOptions.thisMonth) {
                startDate = moment_timezone_1.default().startOf('month');
                endDate = moment_timezone_1.default()
                    .startOf('month')
                    .add(1, 'month');
            }
            else if (type === DatePickerDateOptions.monthToDate) {
                startDate = moment_timezone_1.default().subtract(1, 'month');
                endDate = moment_timezone_1.default();
            }
            else if (type === DatePickerDateOptions.thisYear) {
                startDate = moment_timezone_1.default().startOf('year');
                endDate = moment_timezone_1.default()
                    .startOf('year')
                    .add(1, 'year');
            }
            else if (type === DatePickerDateOptions.yearToDate) {
                startDate = moment_timezone_1.default().subtract(1, 'year');
                endDate = moment_timezone_1.default();
            }
            else if (type === 'date-range' && to && from) {
                startDate = moment_timezone_1.default(from);
                endDate = moment_timezone_1.default(to);
            }
            textJustUsed =
                type === 'date-range' || !type ? type : lodash_1.get(lodash_1.find(commonDates, { id: type }), 'label');
            if (textJustUsed !== undefined && !lodash_1.find(recentlyUsed, ['text', textJustUsed])) {
                recentlyUsed.unshift({ type, text: textJustUsed });
                recentlyUsed = recentlyUsed.slice(0, 5);
            }
            return {
                startDate,
                endDate,
                recentlyUsed,
            };
        }
    },
    _a.displayName = 'RangeDatePicker',
    _a));
