"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
var _a;
"use strict";
const react_1 = tslib_1.__importDefault(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const eui_1 = require("@elastic/eui");
const react_2 = require("@kbn/i18n/react");
exports.MetricsSideNav = react_2.injectI18n((_a = class extends react_1.default.PureComponent {
        constructor() {
            super(...arguments);
            this.state = {
                isOpenOnMobile: false,
            };
            this.toggleOpenOnMobile = () => {
                this.setState({
                    isOpenOnMobile: !this.state.isOpenOnMobile,
                });
            };
        }
        render() {
            let content;
            let mobileContent;
            if (!this.props.loading) {
                const entries = this.props.layouts.map(item => {
                    return {
                        name: item.label,
                        id: item.id,
                        items: item.sections.map(section => ({
                            id: section.id,
                            name: section.label,
                            onClick: this.props.handleClick(section),
                        })),
                    };
                });
                content = react_1.default.createElement(eui_1.EuiSideNav, { items: entries });
                mobileContent = (react_1.default.createElement(eui_1.EuiSideNav, { items: entries, mobileTitle: this.props.nodeName, toggleOpenOnMobile: this.toggleOpenOnMobile, isOpenOnMobile: this.state.isOpenOnMobile }));
            }
            return (react_1.default.createElement(eui_1.EuiPageSideBar, null,
                react_1.default.createElement(eui_1.EuiHideFor, { sizes: ['xs', 's'] },
                    react_1.default.createElement(SideNavContainer, null, content)),
                react_1.default.createElement(eui_1.EuiShowFor, { sizes: ['xs', 's'] }, mobileContent)));
        }
    },
    _a.displayName = 'MetricsSideNav',
    _a));
const SideNavContainer = styled_components_1.default.div `
  position: fixed;
  z-index: 1;
  height: 88vh;
  padding-left: 16px;
  margin-left: -16px;
  overflow-y: auto;
  overflow-x: hidden;
`;
