"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const time_1 = require("../../../../common/time");
class RelativeTime extends React.Component {
    constructor() {
        super(...arguments);
        this.state = {
            currentTime: Date.now(),
            timeoutId: null,
        };
        this.updateCurrentTimeEvery = (refreshInterval) => {
            const nextTimeoutId = window.setTimeout(this.updateCurrentTimeEvery.bind(this, refreshInterval), refreshInterval);
            this.setState({
                currentTime: Date.now(),
                timeoutId: nextTimeoutId,
            });
        };
        this.cancelUpdate = () => {
            const { timeoutId } = this.state;
            if (timeoutId) {
                window.clearTimeout(timeoutId);
                this.setState({
                    timeoutId: null,
                });
            }
        };
    }
    componentDidMount() {
        const { refreshInterval } = this.props;
        if (refreshInterval && refreshInterval > 0) {
            this.updateCurrentTimeEvery(refreshInterval);
        }
    }
    componentWillUnmount() {
        this.cancelUpdate();
    }
    render() {
        const { time } = this.props;
        const { currentTime } = this.state;
        const timeDifference = Math.abs(currentTime - time);
        const timeFragments = time_1.decomposeIntoUnits(timeDifference, unitThresholds);
        if (timeFragments.length === 0) {
            return '0s';
        }
        else {
            return timeFragments.map(time_1.getLabelOfScale).join(' ');
        }
    }
}
exports.RelativeTime = RelativeTime;
const unitThresholds = [time_1.TimeUnit.Day, time_1.TimeUnit.Hour, time_1.TimeUnit.Minute, time_1.TimeUnit.Second];
