"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const polished_1 = require("polished");
const React = tslib_1.__importStar(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const time_1 = require("../../../../common/time");
const item_date_field_1 = require("./item_date_field");
const item_message_field_1 = require("./item_message_field");
exports.LogTextStreamLogEntryItemView = react_1.injectI18n(class extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.state = {
            isHovered: false,
        };
        this.handleMouseEnter = () => {
            this.setState({
                isHovered: true,
            });
        };
        this.handleMouseLeave = () => {
            this.setState({
                isHovered: false,
            });
        };
        this.handleClick = () => {
            this.props.openFlyoutWithItem(this.props.logEntry.gid);
        };
    }
    render() {
        const { intl, boundingBoxRef, logEntry, scale, searchResult, wrap } = this.props;
        const { isHovered } = this.state;
        const viewDetailsLabel = intl.formatMessage({
            id: 'xpack.infra.logEntryItemView.viewDetailsToolTip',
            defaultMessage: 'View Details',
        });
        return (React.createElement(LogTextStreamLogEntryItemDiv, { innerRef: 
            /* Workaround for missing RefObject support in styled-components */
            boundingBoxRef, onMouseEnter: this.handleMouseEnter, onMouseLeave: this.handleMouseLeave },
            React.createElement(item_date_field_1.LogTextStreamItemDateField, { hasHighlights: !!searchResult, isHovered: isHovered, scale: scale }, time_1.formatTime(logEntry.fields.time)),
            React.createElement(LogTextStreamIconDiv, { isHovered: isHovered }, isHovered ? (React.createElement(eui_1.EuiToolTip, { content: viewDetailsLabel },
                React.createElement(eui_1.EuiButtonIcon, { onClick: this.handleClick, iconType: "expand", "aria-label": viewDetailsLabel }))) : (React.createElement(EmptyIcon, null))),
            React.createElement(item_message_field_1.LogTextStreamItemMessageField, { highlights: searchResult ? searchResult.matches.message || [] : [], isHovered: isHovered, isWrapped: wrap, scale: scale }, logEntry.fields.message)));
    }
});
const EmptyIcon = styled_components_1.default.div `
  width: 24px;
`;
const LogTextStreamIconDiv = styled_components_1.default('div') `
  flex-grow: 0;
  background-color: ${props => props.isHovered
    ? props.theme.darkMode
        ? polished_1.transparentize(0.9, polished_1.darken(0.05, props.theme.eui.euiColorHighlight))
        : polished_1.darken(0.05, props.theme.eui.euiColorHighlight)
    : 'transparent'};
  text-align: center;
  user-select: none;
  font-size: 0.9em;
`;
const LogTextStreamLogEntryItemDiv = styled_components_1.default.div `
  font-family: ${props => props.theme.eui.euiCodeFontFamily};
  font-size: ${props => props.theme.eui.euiFontSize};
  line-height: ${props => props.theme.eui.euiLineHeight};
  color: ${props => props.theme.eui.euiTextColor};
  overflow: hidden;
  display: flex;
  flex-direction: row;
  flex-wrap: nowrap;
  justify-content: flex-start;
  align-items: stretch;
`;
