"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const polished_1 = require("polished");
const React = tslib_1.__importStar(require("react"));
const styled_components_1 = require("styled-components");
const styles_1 = require("../../../utils/styles");
const item_field_1 = require("./item_field");
class LogTextStreamItemDateField extends React.PureComponent {
    render() {
        const { children, hasHighlights, isHovered, scale } = this.props;
        return (React.createElement(LogTextStreamItemDateFieldWrapper, { hasHighlights: hasHighlights, isHovered: isHovered, scale: scale }, children));
    }
}
exports.LogTextStreamItemDateField = LogTextStreamItemDateField;
const highlightedFieldStyle = styled_components_1.css `
  background-color: ${props => styles_1.tintOrShade(props.theme.eui.euiTextColor, props.theme.eui.euiColorSecondary, 0.15)};
  border-color: ${props => props.theme.eui.euiColorSecondary};
`;
const hoveredFieldStyle = styled_components_1.css `
  background-color: ${props => props.theme.darkMode
    ? polished_1.transparentize(0.9, polished_1.darken(0.05, props.theme.eui.euiColorHighlight))
    : polished_1.darken(0.05, props.theme.eui.euiColorHighlight)};
  border-color: ${props => props.theme.darkMode
    ? polished_1.transparentize(0.7, polished_1.darken(0.2, props.theme.eui.euiColorHighlight))
    : polished_1.darken(0.2, props.theme.eui.euiColorHighlight)};
  color: ${props => props.theme.eui.euiColorFullShade};
`;
const LogTextStreamItemDateFieldWrapper = item_field_1.LogTextStreamItemField.extend.attrs({}) `
  background-color: ${props => props.theme.eui.euiColorLightestShade};
  border-right: solid 2px ${props => props.theme.eui.euiColorLightShade};
  color: ${props => props.theme.eui.euiColorDarkShade};
  white-space: pre;
  padding: 0 ${props => props.theme.eui.paddingSizes.l};

  ${props => (props.hasHighlights ? highlightedFieldStyle : '')};
  ${props => (props.isHovered ? hoveredFieldStyle : '')};
`;
