"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importDefault(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
const loading_1 = require("../loading");
exports.LogFlyout = react_1.injectI18n(({ flyoutItem, loading, hideFlyout, setFilter, intl }) => {
    const handleFilter = (field) => () => {
        const filter = `${field.field}:"${field.value}"`;
        setFilter(filter);
    };
    const columns = [
        {
            field: 'field',
            name: intl.formatMessage({
                defaultMessage: 'Field',
                id: 'xpack.infra.logFlyout.fieldColumnLabel',
            }),
            sortable: true,
        },
        {
            field: 'value',
            name: intl.formatMessage({
                defaultMessage: 'Value',
                id: 'xpack.infra.logFlyout.valueColumnLabel',
            }),
            sortable: true,
            render: (name, item) => (react_2.default.createElement("span", null,
                react_2.default.createElement(eui_1.EuiToolTip, { content: intl.formatMessage({
                        id: 'xpack.infra.logFlyout.setFilterTooltip',
                        defaultMessage: 'Set Filter',
                    }) },
                    react_2.default.createElement(eui_1.EuiButtonIcon, { color: "text", iconType: "filter", "aria-label": intl.formatMessage({
                            id: 'xpack.infra.logFlyout.filterAriaLabel',
                            defaultMessage: 'Filter',
                        }), onClick: handleFilter(item) })),
                item.value)),
        },
    ];
    return (react_2.default.createElement(eui_1.EuiFlyout, { onClose: () => hideFlyout(), size: "m" },
        react_2.default.createElement(eui_1.EuiFlyoutHeader, { hasBorder: true },
            react_2.default.createElement(eui_1.EuiTitle, { size: "s" },
                react_2.default.createElement("h3", { id: "flyoutTitle" },
                    react_2.default.createElement(react_1.FormattedMessage, { defaultMessage: "Log event document details", id: "xpack.infra.logFlyout.flyoutTitle" })))),
        react_2.default.createElement(eui_1.EuiFlyoutBody, null, loading || flyoutItem === null ? (react_2.default.createElement(exports.InfraFlyoutLoadingPanel, null,
            react_2.default.createElement(loading_1.InfraLoadingPanel, { height: "100%", width: "100%", text: intl.formatMessage({
                    id: 'xpack.infra.logFlyout.loadingMessage',
                    defaultMessage: 'Loading Event',
                }) }))) : (react_2.default.createElement(eui_1.EuiBasicTable, { columns: columns, items: flyoutItem.fields })))));
});
exports.InfraFlyoutLoadingPanel = styled_components_1.default.div `
  position: absolute;
  top: 0;
  right: 0;
  bottom: 0;
  left: 0;
`;
