"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const react_fast_compare_1 = tslib_1.__importDefault(require("react-fast-compare"));
// @ts-ignore
const react_shortcuts_1 = require("react-shortcuts");
// @ts-ignore
const clipboard_1 = require("../../lib/clipboard");
// @ts-ignore
const clone_subgraphs_1 = require("../../lib/clone_subgraphs");
// @ts-ignore
const notify_1 = require("../../lib/notify");
class WorkpadShortcuts extends react_1.Component {
    render() {
        const { pageId } = this.props;
        return (react_1.default.createElement(react_shortcuts_1.Shortcuts, { name: "ELEMENT", handler: (action, event) => this._keyHandler(action, event), targetNodeSelector: `#${pageId}`, global: true }));
    }
    shouldComponentUpdate(nextProps) {
        return !react_fast_compare_1.default(nextProps, this.props);
    }
    _keyHandler(action, event) {
        event.preventDefault();
        switch (action) {
            case 'COPY':
                this._copyElements();
                break;
            case 'CLONE':
                this._duplicateElements();
                break;
            case 'CUT':
                this._cutElements();
                break;
            case 'DELETE':
                this._removeElements();
                break;
            case 'PASTE':
                this._pasteElements();
                break;
            case 'BRING_FORWARD':
                this._bringForward();
                break;
            case 'BRING_TO_FRONT':
                this._bringToFront();
                break;
            case 'SEND_BACKWARD':
                this._sendBackward();
                break;
            case 'SEND_TO_BACK':
                this._sendToBack();
                break;
            case 'GROUP':
                this.props.groupElements();
                break;
            case 'UNGROUP':
                this.props.ungroupElements();
                break;
        }
    }
    _removeElements() {
        const { pageId, removeElements, selectedElementIds } = this.props;
        // currently, handle the removal of one element, exploiting multiselect subsequently
        if (selectedElementIds.length) {
            removeElements(pageId)(selectedElementIds);
        }
    }
    _copyElements() {
        const { selectedElements, selectedPrimaryShapes } = this.props;
        if (selectedElements.length) {
            clipboard_1.setClipboardData({ selectedElements, rootShapes: selectedPrimaryShapes });
            notify_1.notify.success('Copied element to clipboard');
        }
    }
    _cutElements() {
        const { pageId, removeElements, selectedElements, selectedElementIds, selectedPrimaryShapes, } = this.props;
        if (selectedElements.length) {
            clipboard_1.setClipboardData({ selectedElements, rootShapes: selectedPrimaryShapes });
            removeElements(pageId)(selectedElementIds);
            notify_1.notify.success('Copied element to clipboard');
        }
    }
    // TODO: This is slightly different from the duplicateElements function in sidebar/index.js. Should they be doing the same thing?
    // This should also be abstracted.
    _duplicateElements() {
        const { insertNodes, pageId, selectElement, selectedElements, selectedPrimaryShapes, } = this.props;
        const clonedElements = selectedElements && clone_subgraphs_1.cloneSubgraphs(selectedElements);
        if (clonedElements) {
            insertNodes(pageId)(clonedElements);
            if (selectedPrimaryShapes.length) {
                if (selectedElements.length > 1) {
                    // adHocGroup branch (currently, pasting will leave only the 1st element selected, rather than forming a
                    // new adHocGroup - todo)
                    selectElement(clonedElements[0].id);
                }
                else {
                    // single element or single persistentGroup branch
                    selectElement(clonedElements[selectedElements.findIndex(s => s.id === selectedPrimaryShapes[0])].id);
                }
            }
        }
    }
    _pasteElements() {
        const { insertNodes, pageId, selectElement } = this.props;
        const { selectedElements, rootShapes } = JSON.parse(clipboard_1.getClipboardData()) || {
            selectedElements: [],
            rootShapes: [],
        };
        const clonedElements = selectedElements && clone_subgraphs_1.cloneSubgraphs(selectedElements);
        if (clonedElements) {
            // first clone and persist the new node(s)
            insertNodes(pageId)(clonedElements);
            // then select the cloned node
            if (rootShapes.length) {
                if (selectedElements.length > 1) {
                    // adHocGroup branch (currently, pasting will leave only the 1st element selected, rather than forming a
                    // new adHocGroup - todo)
                    selectElement(clonedElements[0].id);
                }
                else {
                    // single element or single persistentGroup branch
                    selectElement(clonedElements[selectedElements.findIndex((s) => s.id === rootShapes[0])].id);
                }
            }
        }
    }
    // TODO: Same as above. Abstract these out. This is the same code as in sidebar/index.js
    // Note: these layer actions only work when a single element is selected
    _bringForward() {
        const { elementLayer, pageId, selectedElements } = this.props;
        if (selectedElements.length === 1) {
            elementLayer(pageId, selectedElements[0], 1);
        }
    }
    _bringToFront() {
        const { elementLayer, pageId, selectedElements } = this.props;
        if (selectedElements.length === 1) {
            elementLayer(pageId, selectedElements[0], Infinity);
        }
    }
    _sendBackward() {
        const { elementLayer, pageId, selectedElements } = this.props;
        if (selectedElements.length === 1) {
            elementLayer(pageId, selectedElements[0], -1);
        }
    }
    _sendToBack() {
        const { elementLayer, pageId, selectedElements } = this.props;
        if (selectedElements.length === 1) {
            elementLayer(pageId, selectedElements[0], -Infinity);
        }
    }
}
exports.WorkpadShortcuts = WorkpadShortcuts;
