/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */

import React from 'react';
import PropTypes from 'prop-types';
import { EuiButtonIcon, EuiFlexGroup, EuiFlexItem } from '@elastic/eui';
import { TooltipIcon } from '../tooltip_icon';

// This is what is being generated by render() from the Arg class. It is called in FunctionForm
export const ArgSimpleForm = ({ children, required, valueMissing, onRemove }) => {
  return (
    <EuiFlexGroup alignItems="center" gutterSize="s" className="canvasArg__form">
      <EuiFlexItem>{children}</EuiFlexItem>
      {valueMissing && (
        <EuiFlexItem grow={false}>
          <TooltipIcon
            position="left"
            icon="error"
            content="This argument is required, you should specify a value."
          />
        </EuiFlexItem>
      )}

      {!required && (
        <EuiButtonIcon
          color="danger"
          onClick={onRemove}
          iconType="trash"
          aria-label="Remove"
          className="canvasArg__remove"
        />
      )}
    </EuiFlexGroup>
  );
};

ArgSimpleForm.propTypes = {
  children: PropTypes.node,
  required: PropTypes.bool,
  valueMissing: PropTypes.bool,
  onRemove: PropTypes.func.isRequired,
};
