"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
// @ts-ignore
const boom_1 = tslib_1.__importDefault(require("boom"));
/**
 * Wraps ES errors into a Boom error response and returns it
 * This also handles the permissions issue gracefully
 *
 * @param err Object ES error
 * @return Object Boom error response
 */
function wrapEsError(err) {
    const statusCode = err.statusCode;
    if (statusCode === 403) {
        return boom_1.default.forbidden('Insufficient user permissions for managing Beats configuration');
    }
    return boom_1.default.boomify(err, { statusCode: err.statusCode });
}
exports.wrapEsError = wrapEsError;
