"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const joi_1 = tslib_1.__importDefault(require("joi"));
const lodash_1 = require("lodash");
const constants_1 = require("../../../common/constants");
const error_wrappers_1 = require("../../utils/error_wrappers");
// TODO: write to Kibana audit log file
exports.createSetTagRoute = (libs) => ({
    method: 'PUT',
    path: '/api/beats/tag/{tagId}',
    licenseRequired: constants_1.REQUIRED_LICENSES,
    requiredRoles: ['beats_admin'],
    config: {
        validate: {
            params: joi_1.default.object({
                tagId: joi_1.default.string(),
            }),
            payload: joi_1.default.object({
                color: joi_1.default.string(),
                name: joi_1.default.string(),
            }),
        },
    },
    handler: async (request) => {
        const defaultConfig = {
            id: request.params.tagId,
            name: request.params.tagId,
            color: '#DD0A73',
            hasConfigurationBlocksTypes: [],
        };
        const config = { ...defaultConfig, ...lodash_1.get(request, 'payload', {}) };
        try {
            const id = await libs.tags.upsertTag(request.user, config);
            return { success: true, id };
        }
        catch (err) {
            // TODO move this to kibana route thing in adapter
            return error_wrappers_1.wrapEsError(err);
        }
    },
});
