"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const error_wrappers_1 = require("../../utils/error_wrappers");
exports.createGetBeatRoute = (libs) => ({
    method: 'GET',
    path: '/api/beats/agent/{beatId}/{token?}',
    requiredRoles: ['beats_admin'],
    handler: async (request, h) => {
        const beatId = request.params.beatId;
        let beat;
        if (beatId === 'unknown') {
            try {
                beat = await libs.beats.getByEnrollmentToken(request.user, request.params.token);
                if (beat === null) {
                    return h.response().code(200);
                }
            }
            catch (err) {
                return error_wrappers_1.wrapEsError(err);
            }
        }
        else {
            try {
                beat = await libs.beats.getById(request.user, beatId);
                if (beat === null) {
                    return h.response({ message: 'Beat not found' }).code(404);
                }
            }
            catch (err) {
                return error_wrappers_1.wrapEsError(err);
            }
        }
        delete beat.access_token;
        return beat;
    },
});
