"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
const joi_1 = tslib_1.__importDefault(require("joi"));
const error_wrappers_1 = require("../../utils/error_wrappers");
exports.beatEventsRoute = (libs) => ({
    method: 'POST',
    path: '/api/beats/{beatId}/events',
    config: {
        validate: {
            headers: joi_1.default.object({
                'kbn-beats-access-token': joi_1.default.string().required(),
            }).options({ allowUnknown: true }),
        },
        auth: false,
    },
    handler: async (request, h) => {
        const beatId = request.params.beatId;
        const events = request.payload;
        const accessToken = request.headers['kbn-beats-access-token'];
        try {
            const beat = await libs.beats.getById(libs.framework.internalUser, beatId);
            if (beat === null) {
                return h.response({ message: `Beat "${beatId}" not found` }).code(400);
            }
            const isAccessTokenValid = beat.access_token === accessToken;
            if (!isAccessTokenValid) {
                return h.response({ message: 'Invalid access token' }).code(401);
            }
            const results = await libs.beatEvents.log(libs.framework.internalUser, beat.id, events);
            return {
                response: results,
            };
        }
        catch (err) {
            return error_wrappers_1.wrapEsError(err);
        }
    },
});
