"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const adapter_types_1 = require("./../framework/adapter_types");
class KibanaDatabaseAdapter {
    constructor(kbnElasticSearch) {
        this.es = kbnElasticSearch.getCluster('admin');
    }
    async get(user, params) {
        const result = await this.callWithUser(user, 'get', params);
        return result;
        // todo
    }
    async mget(user, params) {
        const result = await this.callWithUser(user, 'mget', params);
        return result;
        // todo
    }
    async bulk(user, params) {
        const result = await this.callWithUser(user, 'bulk', params);
        return result;
    }
    async create(user, params) {
        const result = await this.callWithUser(user, 'create', params);
        return result;
    }
    async index(user, params) {
        const result = await this.callWithUser(user, 'index', params);
        return result;
    }
    async delete(user, params) {
        const result = await this.callWithUser(user, 'delete', params);
        return result;
    }
    async deleteByQuery(user, params) {
        const result = await this.callWithUser(user, 'deleteByQuery', params);
        return result;
    }
    async search(user, params) {
        const result = await this.callWithUser(user, 'search', params);
        return result;
    }
    async searchAll(user, params) {
        const result = await this.callWithUser(user, 'search', {
            scroll: '1m',
            ...params,
            body: {
                size: 1000,
                ...params.body,
            },
        });
        return result;
    }
    async putTemplate(name, template) {
        const result = await this.callWithUser({ kind: 'internal' }, 'indices.putTemplate', {
            name,
            body: template,
            include_type_name: true,
        });
        return result;
    }
    callWithUser(user, esMethod, options = {}) {
        if (user.kind === 'authenticated') {
            return this.es.callWithRequest({
                headers: user[adapter_types_1.internalAuthData],
            }, esMethod, options);
        }
        else if (user.kind === 'internal') {
            return this.es.callWithInternalUser(esMethod, options);
        }
        else {
            throw new Error('Invalid user type');
        }
    }
}
exports.KibanaDatabaseAdapter = KibanaDatabaseAdapter;
