"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const security_1 = require("../../common/constants/security");
class FrameworkLib {
    constructor(adapter) {
        this.adapter = adapter;
        this.waitUntilFrameworkReady = this.adapter.waitUntilFrameworkReady.bind(this.adapter);
        this.renderUIAtPath = this.adapter.renderUIAtPath.bind(this.adapter);
        this.registerManagementSection = this.adapter.registerManagementSection.bind(this.adapter);
        this.registerManagementUI = this.adapter.registerManagementUI.bind(this.adapter);
        this.setUISettings = this.adapter.setUISettings.bind(this.adapter);
        this.getUISetting = this.adapter.getUISetting.bind(this.adapter);
    }
    get currentUser() {
        return this.adapter.currentUser;
    }
    get info() {
        return this.adapter.info;
    }
    licenseIsAtLeast(type) {
        return (security_1.LICENSES.indexOf(lodash_1.get(this.adapter.info, 'license.type', 'oss')) >= security_1.LICENSES.indexOf(type));
    }
    versionGreaterThen(version) {
        const pa = this.adapter.version.split('.');
        const pb = version.split('.');
        for (let i = 0; i < 3; i++) {
            const na = Number(pa[i]);
            const nb = Number(pb[i]);
            // version is greater
            if (na > nb) {
                return true;
            }
            // version is less then
            if (nb > na) {
                return false;
            }
            if (!isNaN(na) && isNaN(nb)) {
                return true;
            }
            if (isNaN(na) && !isNaN(nb)) {
                return false;
            }
        }
        return true;
    }
    currentUserHasOneOfRoles(roles) {
        // If the user has at least one of the roles requested, the returnd difference will be less
        // then the orig array size. difference only compares based on the left side arg
        return lodash_1.difference(roles, lodash_1.get(this.currentUser, 'roles', [])).length < roles.length;
    }
}
exports.FrameworkLib = FrameworkLib;
