"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// @ts-ignore TODO type this
const es_query_1 = require("@kbn/es-query");
const lodash_1 = require("lodash");
const autocomplete_providers_1 = require("ui/autocomplete_providers");
class RestElasticsearchAdapter {
    constructor(api, indexPatternName) {
        this.api = api;
        this.indexPatternName = indexPatternName;
        this.cachedIndexPattern = null;
    }
    isKueryValid(kuery) {
        try {
            es_query_1.fromKueryExpression(kuery);
        }
        catch (err) {
            return false;
        }
        return true;
    }
    async convertKueryToEsQuery(kuery) {
        if (!this.isKueryValid(kuery)) {
            return '';
        }
        const ast = es_query_1.fromKueryExpression(kuery);
        const indexPattern = await this.getIndexPattern();
        return JSON.stringify(es_query_1.toElasticsearchQuery(ast, indexPattern));
    }
    async getSuggestions(kuery, selectionStart) {
        const autocompleteProvider = autocomplete_providers_1.getAutocompleteProvider('kuery');
        if (!autocompleteProvider) {
            return [];
        }
        const config = {
            get: () => true,
        };
        const indexPattern = await this.getIndexPattern();
        const getAutocompleteSuggestions = autocompleteProvider({
            config,
            indexPatterns: [indexPattern],
            boolFilter: null,
        });
        const results = getAutocompleteSuggestions({
            query: kuery || '',
            selectionStart,
            selectionEnd: selectionStart,
        });
        return results;
    }
    async getIndexPattern() {
        if (this.cachedIndexPattern) {
            return this.cachedIndexPattern;
        }
        const res = await this.api.get(`/api/index_patterns/_fields_for_wildcard?pattern=${this.indexPatternName}`);
        if (lodash_1.isEmpty(res.fields)) {
            return;
        }
        this.cachedIndexPattern = {
            fields: res.fields,
            title: `${this.indexPatternName}`,
        };
        return this.cachedIndexPattern;
    }
}
exports.RestElasticsearchAdapter = RestElasticsearchAdapter;
