"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const polished_1 = require("polished");
const react_1 = tslib_1.__importDefault(require("react"));
const styled_components_1 = tslib_1.__importDefault(require("styled-components"));
class SuggestionItem extends react_1.default.Component {
    render() {
        const { isSelected, onClick, onMouseEnter, suggestion } = this.props;
        return (react_1.default.createElement(SuggestionItemContainer, { isSelected: isSelected, onClick: onClick, onMouseEnter: onMouseEnter },
            react_1.default.createElement(SuggestionItemIconField, { suggestionType: suggestion.type },
                react_1.default.createElement(eui_1.EuiIcon, { type: getEuiIconType(suggestion.type) })),
            react_1.default.createElement(SuggestionItemTextField, null, suggestion.text),
            react_1.default.createElement(SuggestionItemDescriptionField, { dangerouslySetInnerHTML: { __html: suggestion.description } })));
    }
}
SuggestionItem.defaultProps = {
    isSelected: false,
};
exports.SuggestionItem = SuggestionItem;
const SuggestionItemContainer = styled_components_1.default.div `
  display: flex;
  flex-direction: row;
  font-size: ${props => props.theme.eui.default.euiFontSizeS};
  height: ${props => props.theme.eui.default.euiSizeXl};
  white-space: nowrap;
  background-color: ${props => props.isSelected ? props.theme.eui.default.euiColorLightestShade : 'transparent'};
`;
const SuggestionItemField = styled_components_1.default.div `
  align-items: center;
  cursor: pointer;
  display: flex;
  flex-direction: row;
  height: ${props => props.theme.eui.default.euiSizeXl};
  padding: ${props => props.theme.eui.default.euiSizeXs};
`;
const SuggestionItemIconField = SuggestionItemField.extend `
  background-color: ${props => {
    return polished_1.tint(0.1, getEuiIconColor(props.theme, props.suggestionType));
}};
  color: ${props => {
    return getEuiIconColor(props.theme, props.suggestionType);
}};
  flex: 0 0 auto;
  justify-content: center;
  width: ${props => props.theme.eui.default.euiSizeXl};
`;
const SuggestionItemTextField = SuggestionItemField.extend `
  flex: 2 0 0;
  font-family: ${props => props.theme.eui.default.euiCodeFontFamily};
`;
const SuggestionItemDescriptionField = SuggestionItemField.extend `
  flex: 3 0 0;
  p {
    display: inline;
    span {
      font-family: ${props => props.theme.eui.default.euiCodeFontFamily};
    }
  }
`;
const getEuiIconType = (suggestionType) => {
    switch (suggestionType) {
        case 'field':
            return 'kqlField';
        case 'value':
            return 'kqlValue';
        case 'recentSearch':
            return 'search';
        case 'conjunction':
            return 'kqlSelector';
        case 'operator':
            return 'kqlOperand';
        default:
            return 'empty';
    }
};
const getEuiIconColor = (theme, suggestionType) => {
    switch (suggestionType) {
        case 'field':
            return theme.eui.default.euiColorVis7;
        case 'value':
            return theme.eui.default.euiColorVis0;
        case 'operator':
            return theme.eui.default.euiColorVis1;
        case 'conjunction':
            return theme.eui.default.euiColorVis2;
        case 'recentSearch':
        default:
            return theme.eui.default.euiColorMediumShade;
    }
};
