"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const boom_1 = tslib_1.__importDefault(require("boom"));
const joi_1 = tslib_1.__importDefault(require("joi"));
const input_validation_1 = require("../lib/helpers/input_validation");
const setup_request_1 = require("../lib/helpers/setup_request");
const get_transaction_1 = require("../lib/transactions/get_transaction");
const get_spans_1 = require("../lib/transactions/spans/get_spans");
function initTransactionsApi(server) {
    server.route({
        method: 'GET',
        path: `/api/apm/services/{serviceName}/transactions/{transactionId}`,
        options: {
            validate: {
                query: input_validation_1.withDefaultValidators({
                    traceId: joi_1.default.string().allow('') // TODO: this should be a path param and made required by 7.0
                })
            }
        },
        handler: async (req) => {
            const { transactionId } = req.params;
            const { traceId } = req.query;
            const setup = setup_request_1.setupRequest(req);
            const transaction = await get_transaction_1.getTransaction(transactionId, traceId, setup);
            if (transaction) {
                return transaction;
            }
            else {
                throw boom_1.default.notFound('Cannot find the requested page');
            }
        }
    });
    // TODO: this can be removed by 7.0 when v1 compatability can be dropped
    server.route({
        method: 'GET',
        path: `/api/apm/services/{serviceName}/transactions/{transactionId}/spans`,
        options: {
            validate: {
                query: input_validation_1.withDefaultValidators()
            }
        },
        handler: req => {
            const { transactionId } = req.params;
            const setup = setup_request_1.setupRequest(req);
            return get_spans_1.getSpans(transactionId, setup);
        }
    });
}
exports.initTransactionsApi = initTransactionsApi;
