"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const boom_1 = tslib_1.__importDefault(require("boom"));
const input_validation_1 = require("../lib/helpers/input_validation");
const setup_request_1 = require("../lib/helpers/setup_request");
const get_all_metrics_chart_data_1 = require("../lib/metrics/get_all_metrics_chart_data");
const defaultErrorHandler = (err) => {
    // tslint:disable-next-line
    console.error(err.stack);
    throw boom_1.default.boomify(err, { statusCode: 400 });
};
function initMetricsApi(server) {
    server.route({
        method: 'GET',
        path: `/api/apm/services/{serviceName}/metrics/charts`,
        options: {
            validate: {
                query: input_validation_1.withDefaultValidators()
            }
        },
        handler: async (req) => {
            const setup = setup_request_1.setupRequest(req);
            const { serviceName } = req.params;
            return await get_all_metrics_chart_data_1.getAllMetricsChartData({
                setup,
                serviceName
            }).catch(defaultErrorHandler);
        }
    });
}
exports.initMetricsApi = initMetricsApi;
