"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("../../../../common/constants");
// Deprecated and will be removed in 7.0. Only needed for backwards compatability pre 6.5 (introducition of v2 API and distributed tracing)
async function getSpans(transactionId, setup) {
    const { start, end, client, config } = setup;
    const params = {
        index: config.get('apm_oss.spanIndices'),
        body: {
            size: 500,
            query: {
                bool: {
                    filter: [
                        { term: { [constants_1.TRANSACTION_ID]: transactionId } },
                        { term: { [constants_1.PROCESSOR_EVENT]: 'span' } },
                        {
                            range: {
                                '@timestamp': {
                                    gte: start,
                                    lte: end,
                                    format: 'epoch_millis'
                                }
                            }
                        }
                    ]
                }
            },
            sort: [{ [constants_1.SPAN_START]: { order: 'asc' } }]
        }
    };
    const resp = await client('search', params);
    return resp.hits.hits.map(hit => hit._source);
}
exports.getSpans = getSpans;
