"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const ts_optchain_1 = require("ts-optchain");
const constants_1 = require("../../../../common/constants");
async function getTransaction(transactionId, traceId, setup) {
    const { start, end, esFilterQuery, client, config } = setup;
    const filter = [
        { term: { [constants_1.PROCESSOR_EVENT]: 'transaction' } },
        { term: { [constants_1.TRANSACTION_ID]: transactionId } },
        {
            range: {
                '@timestamp': {
                    gte: start,
                    lte: end,
                    format: 'epoch_millis'
                }
            }
        }
    ];
    if (esFilterQuery) {
        filter.push(esFilterQuery);
    }
    if (traceId) {
        filter.push({ term: { [constants_1.TRACE_ID]: traceId } });
    }
    const params = {
        index: config.get('apm_oss.transactionIndices'),
        body: {
            size: 1,
            query: {
                bool: {
                    filter
                }
            }
        }
    };
    const resp = await client('search', params);
    return ts_optchain_1.oc(resp).hits.hits[0]._source();
}
exports.getTransaction = getTransaction;
