"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const ts_optchain_1 = require("ts-optchain");
function getDefaultSample(buckets) {
    const samples = buckets
        .filter(bucket => bucket.count > 0 && bucket.sample)
        .map(bucket => bucket.sample);
    if (lodash_1.isEmpty(samples)) {
        return;
    }
    const middleIndex = Math.floor(samples.length / 2);
    return samples[middleIndex];
}
function bucketTransformer(response) {
    const buckets = response.aggregations.distribution.buckets.map(bucket => {
        const sampleSource = ts_optchain_1.oc(bucket).sample.hits.hits[0]._source();
        const isSampled = ts_optchain_1.oc(sampleSource).transaction.sampled(false);
        const sample = {
            traceId: ts_optchain_1.oc(sampleSource).trace.id(),
            transactionId: ts_optchain_1.oc(sampleSource).transaction.id()
        };
        return {
            key: bucket.key,
            count: bucket.doc_count,
            sample: isSampled ? sample : undefined
        };
    });
    return {
        totalHits: response.hits.total,
        buckets,
        defaultSample: getDefaultSample(buckets)
    };
}
exports.bucketTransformer = bucketTransformer;
