"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const ts_optchain_1 = require("ts-optchain");
async function getMlBucketSize({ serviceName, transactionType, setup }) {
    const { client, start, end } = setup;
    const params = {
        index: `.ml-anomalies-${serviceName}-${transactionType}-high_mean_response_time`.toLowerCase(),
        body: {
            _source: 'bucket_span',
            size: 1,
            query: {
                bool: {
                    must: {
                        exists: {
                            field: 'bucket_span'
                        }
                    },
                    filter: [
                        {
                            range: {
                                timestamp: {
                                    gte: start,
                                    lte: end,
                                    format: 'epoch_millis'
                                }
                            }
                        }
                    ]
                }
            }
        }
    };
    try {
        const resp = await client('search', params);
        return ts_optchain_1.oc(resp).hits.hits[0]._source.bucket_span(0);
    }
    catch (err) {
        const isHttpError = 'statusCode' in err;
        if (isHttpError) {
            return 0;
        }
        throw err;
    }
}
exports.getMlBucketSize = getMlBucketSize;
