"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const moment_1 = tslib_1.__importDefault(require("moment"));
const ts_optchain_1 = require("ts-optchain");
function calculateRelativeImpacts(results) {
    const values = results.map(({ impact }) => impact);
    const max = Math.max(...values);
    const min = Math.min(...values);
    return results.map(bucket => ({
        ...bucket,
        impact: ((bucket.impact - min) / (max - min)) * 100 || 0
    }));
}
function transactionGroupsTransformer({ response, start, end }) {
    const buckets = ts_optchain_1.oc(response).aggregations.transactions.buckets([]);
    const duration = moment_1.default.duration(end - start);
    const minutes = duration.asMinutes();
    const results = buckets.map(bucket => {
        const averageResponseTime = bucket.avg.value;
        const transactionsPerMinute = bucket.doc_count / minutes;
        const impact = bucket.sum.value;
        const sample = bucket.sample.hits.hits[0]._source;
        return {
            name: bucket.key,
            sample,
            p95: bucket.p95.values['95.0'],
            averageResponseTime,
            transactionsPerMinute,
            impact
        };
    });
    return calculateRelativeImpacts(results);
}
exports.transactionGroupsTransformer = transactionGroupsTransformer;
