"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("../../../common/constants");
function transactionGroupsFetcher(setup, bodyQuery) {
    const { esFilterQuery, client, config } = setup;
    const params = {
        index: config.get('apm_oss.transactionIndices'),
        body: {
            size: 0,
            query: bodyQuery,
            aggs: {
                transactions: {
                    terms: {
                        field: `${constants_1.TRANSACTION_NAME}.keyword`,
                        order: { sum: 'desc' },
                        size: config.get('xpack.apm.ui.transactionGroupBucketSize')
                    },
                    aggs: {
                        sample: {
                            top_hits: {
                                size: 1,
                                sort: [
                                    { _score: 'desc' },
                                    { '@timestamp': { order: 'desc' } }
                                ]
                            }
                        },
                        avg: { avg: { field: constants_1.TRANSACTION_DURATION } },
                        p95: {
                            percentiles: { field: constants_1.TRANSACTION_DURATION, percents: [95] }
                        },
                        sum: { sum: { field: constants_1.TRANSACTION_DURATION } }
                    }
                }
            }
        }
    };
    if (esFilterQuery) {
        params.body.query.bool.filter.push(esFilterQuery);
    }
    return client('search', params);
}
exports.transactionGroupsFetcher = transactionGroupsFetcher;
