"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("x-pack/plugins/apm/common/constants");
const get_bucket_size_1 = require("../../helpers/get_bucket_size");
async function fetch({ serviceName, setup }) {
    const { start, end, esFilterQuery, client, config } = setup;
    const { intervalString } = get_bucket_size_1.getBucketSize(start, end, 'auto');
    const filters = [
        { term: { [constants_1.SERVICE_NAME]: serviceName } },
        { term: { [constants_1.PROCESSOR_NAME]: 'metric' } },
        {
            range: { '@timestamp': { gte: start, lte: end, format: 'epoch_millis' } }
        }
    ];
    if (esFilterQuery) {
        filters.push(esFilterQuery);
    }
    const params = {
        index: config.get('apm_oss.metricsIndices'),
        body: {
            size: 0,
            query: { bool: { filter: filters } },
            aggs: {
                timeseriesData: {
                    date_histogram: {
                        field: '@timestamp',
                        interval: intervalString,
                        min_doc_count: 0,
                        extended_bounds: { min: start, max: end }
                    },
                    aggs: {
                        systemCPUAverage: { avg: { field: constants_1.METRIC_SYSTEM_CPU_PERCENT } },
                        systemCPUMax: { max: { field: constants_1.METRIC_SYSTEM_CPU_PERCENT } },
                        processCPUAverage: { avg: { field: constants_1.METRIC_PROCESS_CPU_PERCENT } },
                        processCPUMax: { max: { field: constants_1.METRIC_PROCESS_CPU_PERCENT } }
                    }
                },
                systemCPUAverage: { avg: { field: constants_1.METRIC_SYSTEM_CPU_PERCENT } },
                systemCPUMax: { max: { field: constants_1.METRIC_SYSTEM_CPU_PERCENT } },
                processCPUAverage: { avg: { field: constants_1.METRIC_PROCESS_CPU_PERCENT } },
                processCPUMax: { max: { field: constants_1.METRIC_PROCESS_CPU_PERCENT } }
            }
        }
    };
    return client('search', params);
}
exports.fetch = fetch;
