"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const moment_1 = tslib_1.__importDefault(require("moment"));
function decodeEsQuery(esQuery) {
    return esQuery ? JSON.parse(decodeURIComponent(esQuery)) : null;
}
function setupRequest(req) {
    const query = req.query;
    const cluster = req.server.plugins.elasticsearch.getCluster('data');
    const client = (type, params) => {
        if (query._debug) {
            console.log(`DEBUG ES QUERY:`);
            console.log(`${req.method.toUpperCase()} ${req.url.pathname} ${JSON.stringify(query)}`);
            console.log(`GET ${params.index}/_search`);
            console.log(JSON.stringify(params.body, null, 4));
        }
        const nextParams = {
            ...params,
            rest_total_hits_as_int: true // ensure that ES returns accurate hits.total with pre-6.6 format
        };
        return cluster.callWithRequest(req, type, nextParams);
    };
    return {
        start: moment_1.default.utc(query.start).valueOf(),
        end: moment_1.default.utc(query.end).valueOf(),
        esFilterQuery: decodeEsQuery(query.esFilterQuery),
        client,
        config: req.server.config()
    };
}
exports.setupRequest = setupRequest;
