"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
// Support telemetry for additional agent types by appending definitions in
// mappings.json and the AgentName enum.
var AgentName;
(function (AgentName) {
    AgentName["Python"] = "python";
    AgentName["Java"] = "java";
    AgentName["NodeJs"] = "nodejs";
    AgentName["JsBase"] = "js-base";
    AgentName["Ruby"] = "ruby";
    AgentName["GoLang"] = "go";
})(AgentName = exports.AgentName || (exports.AgentName = {}));
exports.APM_TELEMETRY_DOC_ID = 'apm-telemetry';
function createApmTelementry(agentNames = []) {
    const validAgentNames = agentNames.filter(agentName => Object.values(AgentName).includes(agentName));
    return {
        has_any_services: validAgentNames.length > 0,
        services_per_agent: lodash_1.countBy(validAgentNames)
    };
}
exports.createApmTelementry = createApmTelementry;
function storeApmTelemetry(server, apmTelemetry) {
    const savedObjectsClient = getSavedObjectsClient(server);
    savedObjectsClient.create('apm-telemetry', apmTelemetry, {
        id: exports.APM_TELEMETRY_DOC_ID,
        overwrite: true
    });
}
exports.storeApmTelemetry = storeApmTelemetry;
function getSavedObjectsClient(server) {
    const { SavedObjectsClient, getSavedObjectsRepository } = server.savedObjects;
    const { callWithInternalUser } = server.plugins.elasticsearch.getCluster('admin');
    const internalRepository = getSavedObjectsRepository(callWithInternalUser);
    return new SavedObjectsClient(internalRepository);
}
exports.getSavedObjectsClient = getSavedObjectsClient;
