"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chrome_1 = tslib_1.__importDefault(require("ui/chrome"));
const constants_1 = require("../../../common/constants");
const callApi_1 = require("./callApi");
function getMlPrefix(serviceName, transactionType) {
    return `${serviceName}-${transactionType ? transactionType + '-' : ''}`.toLowerCase();
}
exports.getMlPrefix = getMlPrefix;
async function startMLJob({ serviceName, transactionType }) {
    const indexPatternName = chrome_1.default.getInjected('apmIndexPatternTitle');
    const groups = ['apm', serviceName.toLowerCase()];
    const filter = [{ term: { [constants_1.SERVICE_NAME]: serviceName } }];
    if (transactionType) {
        groups.push(transactionType.toLowerCase());
        filter.push({ term: { [constants_1.TRANSACTION_TYPE]: transactionType } });
    }
    return callApi_1.callApi({
        method: 'POST',
        pathname: `/api/ml/modules/setup/apm_transaction`,
        body: JSON.stringify({
            prefix: getMlPrefix(serviceName, transactionType),
            groups,
            indexPatternName,
            startDatafeed: true,
            query: {
                bool: {
                    filter
                }
            }
        })
    });
}
exports.startMLJob = startMLJob;
async function getMLJob({ serviceName, transactionType, anomalyName = 'high_mean_response_time' }) {
    return callApi_1.callApi({
        method: 'GET',
        pathname: `/api/ml/anomaly_detectors/${getMlPrefix(serviceName, transactionType)}${anomalyName}`
    });
}
exports.getMLJob = getMLJob;
