"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const callApi_1 = require("../callApi");
const apm_1 = require("./apm");
async function loadSpans({ serviceName, start, end, transactionId }) {
    const hits = await callApi_1.callApi({
        pathname: `/api/apm/services/${serviceName}/transactions/${transactionId}/spans`,
        query: {
            start,
            end
        }
    });
    return hits.map(apm_1.addVersion).map(addSpanId);
}
exports.loadSpans = loadSpans;
function addSpanId(hit, i) {
    if (!hit.span.id) {
        hit.span.id = i;
    }
    return hit;
}
async function loadTransaction({ serviceName, start, end, transactionId, traceId, kuery }) {
    try {
        const result = await callApi_1.callApi({
            pathname: `/api/apm/services/${serviceName}/transactions/${transactionId}`,
            query: {
                traceId,
                start,
                end,
                esFilterQuery: await apm_1.getEncodedEsQuery(kuery)
            }
        });
        return apm_1.addVersion(result);
    }
    catch (e) {
        const err = e;
        // swallow 404 errors
        if (err.res.status === 404) {
            return;
        }
        // re-throw all other errors
        throw err;
    }
}
exports.loadTransaction = loadTransaction;
