"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const callApi_1 = require("../callApi");
const apm_1 = require("./apm");
async function loadTransactionList({ serviceName, start, end, kuery, transactionType = 'request' }) {
    const groups = await callApi_1.callApi({
        pathname: `/api/apm/services/${serviceName}/transaction_groups/${transactionType}`,
        query: {
            start,
            end,
            esFilterQuery: await apm_1.getEncodedEsQuery(kuery)
        }
    });
    return groups.map(group => {
        group.sample = apm_1.addVersion(group.sample);
        return group;
    });
}
exports.loadTransactionList = loadTransactionList;
async function loadTransactionDistribution({ serviceName, start, end, transactionName, transactionType = 'request', transactionId, traceId, kuery }) {
    return callApi_1.callApi({
        pathname: `/api/apm/services/${serviceName}/transaction_groups/${transactionType}/${encodeURIComponent(transactionName)}/distribution`,
        query: {
            start,
            end,
            transactionId,
            traceId,
            esFilterQuery: await apm_1.getEncodedEsQuery(kuery)
        }
    });
}
exports.loadTransactionDistribution = loadTransactionDistribution;
async function loadDetailsCharts({ serviceName, start, end, kuery, transactionType = 'request', transactionName }) {
    return callApi_1.callApi({
        pathname: `/api/apm/services/${serviceName}/transaction_groups/${transactionType}/${encodeURIComponent(transactionName)}/charts`,
        query: {
            start,
            end,
            esFilterQuery: await apm_1.getEncodedEsQuery(kuery)
        }
    });
}
exports.loadDetailsCharts = loadDetailsCharts;
async function loadOverviewCharts({ serviceName, start, end, kuery, transactionType = 'request' }) {
    return callApi_1.callApi({
        pathname: `/api/apm/services/${serviceName}/transaction_groups/${transactionType}/charts`,
        query: {
            start,
            end,
            esFilterQuery: await apm_1.getEncodedEsQuery(kuery)
        }
    });
}
exports.loadOverviewCharts = loadOverviewCharts;
async function loadOverviewChartsForAllTypes({ serviceName, start, end, kuery }) {
    return callApi_1.callApi({
        pathname: `/api/apm/services/${serviceName}/transaction_groups/charts`,
        query: {
            start,
            end,
            esFilterQuery: await apm_1.getEncodedEsQuery(kuery)
        }
    });
}
exports.loadOverviewChartsForAllTypes = loadOverviewChartsForAllTypes;
