"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const callApi_1 = require("../callApi");
const apm_1 = require("./apm");
async function loadTrace({ traceId, start, end }) {
    const hits = await callApi_1.callApi({
        pathname: `/api/apm/traces/${traceId}`,
        query: {
            start,
            end
        }
    });
    return hits.map(apm_1.addVersion);
}
exports.loadTrace = loadTrace;
async function loadTraceList({ start, end, kuery }) {
    const groups = await callApi_1.callApi({
        pathname: '/api/apm/traces',
        query: {
            start,
            end,
            esFilterQuery: await apm_1.getEncodedEsQuery(kuery)
        }
    });
    return groups.map(group => {
        group.sample = apm_1.addVersion(group.sample);
        return group;
    });
}
exports.loadTraceList = loadTraceList;
