"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const kuery_1 = require("../../kuery");
async function getEncodedEsQuery(kuery) {
    if (!kuery) {
        return;
    }
    const indexPattern = await kuery_1.getAPMIndexPatternForKuery();
    if (!indexPattern) {
        return;
    }
    const esFilterQuery = kuery_1.convertKueryToEsQuery(kuery, indexPattern);
    return encodeURIComponent(JSON.stringify(esFilterQuery));
}
exports.getEncodedEsQuery = getEncodedEsQuery;
function addVersion(item) {
    if (item != null) {
        item.version = item.hasOwnProperty('trace') ? 'v2' : 'v1';
    }
    return item;
}
exports.addVersion = addVersion;
