"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const es_query_1 = require("@kbn/es-query");
const autocomplete_providers_1 = require("ui/autocomplete_providers");
// @ts-ignore
const static_utils_1 = require("ui/index_patterns/static_utils");
const savedObjects_1 = require("./rest/savedObjects");
function convertKueryToEsQuery(kuery, indexPattern) {
    const ast = es_query_1.fromKueryExpression(kuery);
    return es_query_1.toElasticsearchQuery(ast, indexPattern);
}
exports.convertKueryToEsQuery = convertKueryToEsQuery;
async function getSuggestions(query, selectionStart, apmIndexPattern, boolFilter) {
    const autocompleteProvider = autocomplete_providers_1.getAutocompleteProvider('kuery');
    if (!autocompleteProvider) {
        return [];
    }
    const config = {
        get: () => true
    };
    const getAutocompleteSuggestions = autocompleteProvider({
        config,
        indexPatterns: [apmIndexPattern],
        boolFilter
    });
    return getAutocompleteSuggestions({
        query,
        selectionStart,
        selectionEnd: selectionStart
    });
}
exports.getSuggestions = getSuggestions;
async function getAPMIndexPatternForKuery() {
    const apmIndexPattern = await savedObjects_1.getAPMIndexPattern();
    if (!apmIndexPattern) {
        return;
    }
    return static_utils_1.getFromSavedObject(apmIndexPattern);
}
exports.getAPMIndexPatternForKuery = getAPMIndexPatternForKuery;
